/***************************************************************************
 *
 * Copyright 2012 BMW Car IT GmbH
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ****************************************************************************/

#ifndef _SCENEPROVIDER_
#define _SCENEPROVIDER_

#include "ISceneProvider.h"
#include "PluginBase.h"

class ICommandExecutor;
class Configuration;

/**
 * scene Providers to setup a inital layer scenary on target platform
 */
class AIVISceneProvider : public ISceneProvider, public IPlugin
{
public:

    AIVISceneProvider(ICommandExecutor& executor, Configuration& config);
    //virtual ~AditSceneProvider() {}

    // from ISceneProvider
    virtual bool delegateScene();

    //from IPlugin
    virtual t_ilm_const_string pluginGetName() const;
    virtual int getIterationCounter();
    virtual PluginApi pluginGetApi() const;
    virtual HealthCondition pluginGetHealth();

protected:
    ICommandExecutor& mExecutor;
    Configuration& mConfiguration;

private:
    unsigned int* find_max_resolution(unsigned int* scr_ids, int num_ids);
	bool CreateSceneLayers(struct t_layerScene stLayerScene[], unsigned int num_layers, unsigned int nScreenID);
};

#endif /* _SCENEPROVIDER_ */
